# Import required Python libraries
import time
import RPi.GPIO as GPIO
import subprocess
from lcd23008 import Adafruit_CharLCDPlate
import smbus
from datetime import datetime
GPIO.setmode(GPIO.BOARD) 
GPIO.setwarnings(False)
# use busnum = 0 for raspi version 1 (256MB) and busnum = 1 for version 2
lcd = Adafruit_CharLCDPlate(busnum = 0)
lcd.begin(16,2)    #16 char 2 line LCD
lcd.clear()

#welcome message
exitCode = subprocess.call(["espeak","-ven+k9","-a200","Welcome to Raspberry Pi Distance measuring robotics, You may like to set the volume high"])
GPIO.setmode(GPIO.BCM)
GPIO_TRIGGER = 25  #pin 22
GPIO_ECHO    = 8   #pin 24
x=17               #pin 11
y=18               #pin 12
z=0
a=[]
sv = 5            #Set value to compare before speak up
GPIO.setup(x,GPIO.OUT)
GPIO.setup(y,GPIO.OUT)
GPIO.output(x,0)
GPIO.output(y,0)

#print "Ultrasonic Measurement"
GPIO.setup(GPIO_TRIGGER,GPIO.OUT)  # Trigger
GPIO.setup(GPIO_ECHO,GPIO.IN)      # Echo

while True:
    GPIO.output(GPIO_TRIGGER, False)
    time.sleep(0.5)
# Send 10us pulse to trigger
    GPIO.output(GPIO_TRIGGER, True)
    time.sleep(0.00001)

    GPIO.output(GPIO_TRIGGER, False)
    start = time.time()
    while GPIO.input(GPIO_ECHO)==0:
           start = time.time()
    while GPIO.input(GPIO_ECHO)==1:
           stop = time.time()
    elapsed = stop-start
#multiplied speed of sound (cm/s)
    distance = elapsed * 34300 / 2
    a.append(distance)
    lcd.setCursor(0,0)
    lcd.message("TIME -------- CM")
    lcd.setCursor(0,1)
    buf = "%.2f" % distance
    if distance>99:
          lcd.message(datetime.now().strftime('%H:%M:%S  ')+buf)
    if distance<=99:
          if distance>9:
           lcd.message(datetime.now().strftime('%H:%M:%S   ')+buf)
    if distance<=9: 
          lcd.message(datetime.now().strftime('%H:%M:%S    ')+buf)

    print z," Distance : %.1f cm" % distance
    if z==0:
        exitCode = subprocess.call(["espeak","-ven+f3","-a200","Distance is %.2f centi meter" % a[0] ])

    if abs(a[z-1]-a[z])>=sv:
        time.sleep(0.5)
#        print "%.2f" % abs(a[z-1]-a[z])
        exitCode = subprocess.call(["espeak","-ven+f3","-a200","Distance is %.2f centi meter" % distance])

    if distance>=200:
         GPIO.output(x,1)
         GPIO.output(y,0)

    if distance<=100:
         GPIO.output(y,1)
         GPIO.output(x,0)
    z=z+1
    if z>19:
       z=0

#    print z
#    print a[z-2]
#   exitCode = subprocess.call(["espeak","-ven+f3", "Distance is %.2f centi meter" % distance])


